package com.valiantys.nfeed.api;

/**
 *
 */
public interface IFieldDisplayService {

    /**
     * Retrieves the display value of an Elements Connect custom field for issue view
     *
     * @param issueId       id of issue to retrieve display value from
     * @param customFieldId id of Elements Connect custom field (customfield_XXX)
     * @return the display result {@link FieldDisplayResult}
     */
    FieldDisplayResult getDisplayResult(Long issueId, String customFieldId);

    /**
     * Retrieves the display value of an Elements Connect custom field for issue view
     *
     * @param issueKey      key of issue to retrieve display value from
     * @param customFieldId id of Elements Connect custom field (customfield_XXX)
     * @return the display result {@link FieldDisplayResult}
     */
    FieldDisplayResult getDisplayResult(String issueKey, String customFieldId);

    /**
     * Retrieves the display value of an Elements Connect custom field for issue view overriding user permissions
     *
     * @param issueId       id of issue to retrieve display value from
     * @param customFieldId id of Elements Connect custom field (customfield_XXX)
     * @return the display result {@link FieldDisplayResult}
     */
    FieldDisplayResult getDisplayResultOverrideSecurity(Long issueId, String customFieldId);

    /**
     * Retrieves the display value of an Elements Connect custom field for issue view overriding user permissions
     *
     * @param issueKey      key of issue to retrieve display value from
     * @param customFieldId id of Elements Connect custom field (customfield_XXX)
     * @return the display result {@link FieldDisplayResult}
     */
    FieldDisplayResult getDisplayResultOverrideSecurity(String issueKey, String customFieldId);
}
