package com.valiantys.nfeed.api;

import java.util.Collection;

/**
 * This service gives access to nFeed custom field value.
 * Using the methods below, you can set and get custom field content.
 * The value type must match the nFeed custom field type :
 * <ul>
 * <li>nFeed : java.lang.String (key content)</li>
 * <li>nFeed legacy : java.lang.String (key content)</li>
 * <li>nFeed Date : java.util.Date</li>
 * <li>nFeed DateTime: java.util.Date</li>
 * <li>nFeed User : com.atlassian.jira.ApplicationUser</li>
 * </ul>
 */
public interface IFieldValueService {

    /**
     * Sets a nFeed custom field value.
     * This works exactly the same as using {@link #setFieldValues(String, String, Collection)} with a Collection containing this single element.
     * Setting null will set an empty collection.
     *
     * @param issueKey      The issue key
     * @param customFieldId the custom field id (customfield_XXX)
     * @param fieldValue    the field value.
     */
    void setFieldValue(String issueKey, String customFieldId, Object fieldValue);

    /**
     * Sets a nFeed custom field values.
     * The values must match the type of the custom field (see class declaration javadoc).
     * When setting values on a single value field, only the first value in the collection will be taken into account.
     * If the issue does not exist or if the custom field does not exist or is not a nFeed field, the method has no effect.
     *
     * @param issueKey      the issue key
     * @param customFieldId the custom field id
     * @param fieldValues   a collection of values
     */
    void setFieldValues(String issueKey, String customFieldId, Collection<?> fieldValues);

    /**
     * Returns the values contained in the nFeed custom field.
     * Single value field return a collection with at most one value.
     * If the issue does not exist or if the custom field does not exist or is not a nFeed field, the method returns an empty list.
     *
     * @param issueKey      the issue key
     * @param customFieldId the custom field id
     * @return a collection of values
     */
    Collection<?> getFieldValues(String issueKey, String customFieldId);
}
